/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.codec.serviceimpl;

import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.ext.serviceapi.*;
import org.doopyon.ravanelab.nn.domain.*;
import org.doopyon.ravanelab.util.encoding.serviceapi.*;
import org.springframework.beans.factory.annotation.*;
import org.springframework.stereotype.*;


/**
 * Implementation of MatchCodecService.
 * 
 * @author Olivier PARISOT
 */
@Service(MatchCodecServiceImpl.BEAN_ID)
public class MatchCodecServiceImpl extends MatchCodecServiceImplBase 
{
	//
	// Instance fields
	//
	
	/** The working encoding strategy. */
	private EncodingStrategy encodingStrategy;
	
	/** The working team infos service. */
	private TeamInfosFinderService teamInfosService;
	
	//
	// Instance methods
	//
	
	/**
	 * Set the encoding strategy.
	 * @param encodingStrategy the encodingStrategy to set
	 */
	@Autowired
	public final void setEncodingStrategy(@Qualifier(EncodingStrategy.BEAN_ID) final EncodingStrategy encodingStrategy) 
	{
		this.encodingStrategy=encodingStrategy;
	}		
	
	/**
	 * Set team infos service.
	 * @param encodingStrategy the team infos service
	 */
	@Autowired
	public final void setTeamInfosService(@Qualifier(TeamInfosFinderService.BEAN_ID) final TeamInfosFinderService teamInfosService) 
	{
		this.teamInfosService=teamInfosService;
	}	
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public final NeuralNetworkData getEncodedMatch(final Match match,final LeagueSeasonRanking ranking) 
	{
		final int nbTeams=ranking.getLeagueSeasonRankingByTeams().size();
		final int nbMatchWeeks=2*(nbTeams-1);
		final Team homeTeam=match.getHomeTeam();
		final Team awayTeam=match.getAwayTeam();
		final LeagueSeasonRankingByTeam homeLeagueSeasonRankingByTeam=ranking.getLeagueSeasonRankingByTeam(homeTeam);
		final LeagueSeasonRankingByTeam awayLeagueSeasonRankingByTeam=ranking.getLeagueSeasonRankingByTeam(awayTeam);
				
		final NeuralNetworkData nnd=new NeuralNetworkData();
		nnd.add(encodingStrategy.getEncodedInt(ranking.getLeagueSeasonRankingByTeam(homeTeam).getTotalCountOfPlayedMatchs(),nbMatchWeeks));
		nnd.add(encodingStrategy.getEncodedInt(homeLeagueSeasonRankingByTeam.getCountOfPoints(),100));
		nnd.add(encodingStrategy.getEncodedInt(awayLeagueSeasonRankingByTeam.getCountOfPoints(),100));
		nnd.add(encodingStrategy.getEncodedInt(homeLeagueSeasonRankingByTeam.getCountOfGoalsFor(),100));
		nnd.add(encodingStrategy.getEncodedInt(awayLeagueSeasonRankingByTeam.getCountOfGoalsFor(),100));
		nnd.add(encodingStrategy.getEncodedInt(homeLeagueSeasonRankingByTeam.getCountOfGoalsAgainst(),100));
		nnd.add(encodingStrategy.getEncodedInt(awayLeagueSeasonRankingByTeam.getCountOfGoalsAgainst(),100));
		final int homeBudget=teamInfosService.findBudgetByTeamAndSeasonYear(homeTeam,ranking.getSeasonYear());
		if (homeBudget>0) nnd.add(encodingStrategy.getEncodedInt(homeBudget,200));
		else return null;
		final int awayBudget=teamInfosService.findBudgetByTeamAndSeasonYear(awayTeam,ranking.getSeasonYear());
		if (awayBudget>0) nnd.add(encodingStrategy.getEncodedInt(awayBudget,200));
		else return null;
		
		return nnd;
	}		

}
