/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.codec.serviceimpl;

import java.util.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.nn.domain.*;


/**
 * MatchEvaluationCodecService mode.
 * 
 * @author Olivier PARISOT
 */
public enum MatchEvaluationCodecServiceMode 
{
	//
	// Enum values
	//
	
	/** */
	ALL(MatchEvaluation.RESULT_1,MatchEvaluation.RESULT_N,MatchEvaluation.RESULT_2),
	ONLY_RESULT_1(MatchEvaluation.RESULT_1,MatchEvaluation.UNDEFINED),
	ONLY_RESULT_N(MatchEvaluation.RESULT_N,MatchEvaluation.UNDEFINED),
	ONLY_RESULT_2(MatchEvaluation.RESULT_2,MatchEvaluation.UNDEFINED);
	
	
	//
	// Instance fields
	//
	
	/** */
	private final List<MatchEvaluation> matchEvaluationsToKeepIntoAccount;
	
	
	//
	// Constructors
	//
	
	/**
	 * Constructor.
	 */
	MatchEvaluationCodecServiceMode(final List<MatchEvaluation> matchEvaluationsToKeepIntoAccount)
	{
		this.matchEvaluationsToKeepIntoAccount=matchEvaluationsToKeepIntoAccount;
	}

	/**
	 * Constructor.
	 */
	MatchEvaluationCodecServiceMode(MatchEvaluation... matchEvaluationToKeepIntoAccount)
	{
		this(getMatchEvaluationsList(matchEvaluationToKeepIntoAccount));
	}	
	
	
	//
	// Instance methods
	//	

	/**
	 * 
	 */
    public final NeuralNetworkData getEncodedMatchEvaluation(final MatchEvaluation matchEval) 
    {
    	if (matchEval.equals(MatchEvaluation.NOTPLAYED)) throw new IllegalStateException("Impossible to encode a not played match!");
    	
    	final int lsize=matchEvaluationsToKeepIntoAccount.size();
		final NeuralNetworkData res=new NeuralNetworkData(lsize);
		for (int i=0;i<lsize;i++)
		{
			if (matchEvaluationsToKeepIntoAccount.get(i).equals(matchEval)) res.set(i,1d);
			else res.set(i,0d);
		}
    	return res;
    }

    /**
     * 
     * @param nnd
     * @return
     */
	public final MatchEvaluation getDecodedMatchEvaluation(final NeuralNetworkData nnd) 
	{
		if (nnd.size()!=matchEvaluationsToKeepIntoAccount.size()) throw new IllegalArgumentException("The input should have a size="+matchEvaluationsToKeepIntoAccount.size());				
		
		return matchEvaluationsToKeepIntoAccount.get(nnd.getIndexOfFirstMaxValue());		
	}
	
	
	//
	// Static methods
	//
	
	/**
	 * 
	 */
	private static List<MatchEvaluation> getMatchEvaluationsList(MatchEvaluation... matchEvaluationToKeepIntoAccount) 
	{
    	final List<MatchEvaluation> l=new ArrayList<MatchEvaluation>(matchEvaluationToKeepIntoAccount.length);
    	for (MatchEvaluation d:matchEvaluationToKeepIntoAccount) l.add(d);
    	return l;
	}	
	
}
