/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.core.domain;


/**
 *
 * Value object representing LeagueSeasonRankingByTeam.
 * This class is responsible for the domain object related
 * business logic for LeagueSeasonRankingByTeam. Properties and associations are
 * implemented in the generated base class {@link org.doopyon.ravanelab.core.domain.LeagueSeasonRankingByTeamBase}.
 */
public class LeagueSeasonRankingByTeam extends LeagueSeasonRankingByTeamBase 
{
	//
	// Static fields
	//
	
	/** Serial version UID. */
	private static final long serialVersionUID=9139190183863168791L;

	
	//
	// Constructors
	//	

	/**
	 * Constructor.
	 */
    protected LeagueSeasonRankingByTeam() {}

    /**
     * Constructor.
     * @param numberOfPoints
     * @param numberOfWonMatchs
     * @param numberOfLostMatchs
     * @param numberOfDrawMatchs
     * @param numberOfGoalsFor
     * @param numberOfGoalsAgainst
     * @param rankedTeam
     */
    public LeagueSeasonRankingByTeam(int numberOfPoints, int numberOfWonMatchs,
        int numberOfLostMatchs, int numberOfDrawMatchs, int numberOfGoalsFor,
        int numberOfGoalsAgainst, Team rankedTeam) 
    {
        super(numberOfPoints, numberOfWonMatchs, numberOfLostMatchs,
            numberOfDrawMatchs, numberOfGoalsFor, numberOfGoalsAgainst,
            rankedTeam);
    }
    
    
    //
    // Instance methods
    //

    /**
     * 
     */
    public final LeagueSeasonRankingByTeam withAddingCountOfGoalsFor(final int countOfGoalsForToAdd) 
    {
    	return withCountOfGoalsFor(getCountOfGoalsFor()+countOfGoalsForToAdd);
    }     
    
    /**
     * 
     */
    public final LeagueSeasonRankingByTeam withAddingCountOfGoalsAgainst(final int countOfGoalsAgainstToAdd) 
    {
    	return withCountOfGoalsAgainst(getCountOfGoalsAgainst()+countOfGoalsAgainstToAdd);
    }    
    
    /**
     * 
     */
    public final LeagueSeasonRankingByTeam withAddingCountOfPoints(final int countOfPointsToAdd) 
    {
    	return withCountOfPoints(getCountOfPoints()+countOfPointsToAdd);
    }    
    
    /**
     * 
     */
    public final LeagueSeasonRankingByTeam withAddingCountOfWonMatchs(final int countOfWonMatchsToAdd) 
    {
    	return withCountOfWonMatchs(getCountOfWonMatchs()+countOfWonMatchsToAdd);
    }

    /**
     * 
     * @param countOfLostMatchsToAdd
     * @return
     */
    public final LeagueSeasonRankingByTeam withAddingCountOfLostMatchs(final int countOfLostMatchsToAdd) 
    {
    	return withCountOfLostMatchs(getCountOfLostMatchs()+countOfLostMatchsToAdd);    	
    }
    
    /**
     * 
     * @param countOfDrawMatchsToAdd
     * @return
     */
    public final LeagueSeasonRankingByTeam withAddingCountOfDrawMatchs(final int countOfDrawMatchsToAdd) 
    {
    	return withCountOfDrawMatchs(getCountOfDrawMatchs()+countOfDrawMatchsToAdd);
    }
    
    /**
     * Get the total count of matchs.
     */
    public final int getTotalCountOfPlayedMatchs()
    {
    	return getCountOfWonMatchs()+getCountOfDrawMatchs()+getCountOfLostMatchs();
    }
    
	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String toString()
	{
		final StringBuilder sb=new StringBuilder();
		sb.append(getCountOfPoints()).append("pts ")
		  .append(getTotalCountOfPlayedMatchs()).append("matchs [W|D|L:")
		  .append(getCountOfWonMatchs()).append("|")
		  .append(getCountOfDrawMatchs()).append("|")
		  .append(getCountOfLostMatchs()).append(" GF|GA|DIFF:")
		  .append(getCountOfGoalsFor()).append("|")
		  .append(getCountOfGoalsAgainst()).append("|")
		  .append(getCountOfGoalsFor()-getCountOfGoalsAgainst()).append("]\t")
		  .append(getRankedTeam());		  
		return sb.toString();
	}    
}
