/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.doopyon.ravanelab.core.domain;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 *
 * Entity representing Match.
 * This class is responsible for the domain object related
 * business logic for Match. Properties and associations are
 * implemented in the generated base class {@link org.doopyon.ravanelab.core.domain.MatchBase}.
 */
@Entity
@Table(name = "MATCH")
public class Match extends MatchBase 
{
	//
	// Static fields
	//
	
	/** Serial version UID. */
	private static final long serialVersionUID = 7717158790929074021L;


	//
	// Constructors
	//
	
	/**
	 * Constructor.
	 */
    public Match()
    {
    	super();
    }    
    
	
	//
	// Instance methods
	//
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String toString()
	{	
		final StringBuilder sb=new StringBuilder().append(getHomeTeam()).append(" - ").append(getAwayTeam());
		sb.append(" -> ");
		if (getScore()!=null) sb.append(getScore().getHomePoints())
								.append('-')
								.append(getScore().getAwayPoints());
		else sb.append("[NO SCORE]");
		return sb.toString();
	}
}
