/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.doopyon.ravanelab.core.domain;

import java.util.*;
import javax.persistence.*;


/**
 *
 * Entity representing MatchWeek.
 * This class is responsible for the domain object related
 * business logic for MatchWeek. Properties and associations are
 * implemented in the generated base class {@link org.doopyon.ravanelab.core.domain.MatchWeekBase}.
 */
@Entity
@Table(name = "MATCHWEEK")
public class MatchWeek extends MatchWeekBase 
{
	//
	// Static fields
	//
	
	/** Serial version UID. */
	private static final long serialVersionUID=7717158790929074027L;
	
	
	//
	// Constructors
	//
	
	/**
	 * Constructor.
	 */
    protected MatchWeek()
    {
    	super();
    }    
	
	/**
	 * Constructor.
	 */
	public MatchWeek(int matchWeekOrder)
	{
		super(matchWeekOrder);
	}
	
	
	//
    // Instance methods
    //    

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String toString()
	{
		final StringBuilder sb=new StringBuilder("MatchWeek ").append(getMatchWeekOrder()).append(" [matchs-count=").append(getMatchs().size()).append("] :\n");		
		for (Match m:getMatchs()) sb.append(m).append("\n");				
		return sb.toString();
	}
	
	/**
	 * Get the list of the referenced teams in this match week.
	 * @return the list of the referenced teams in this match week
	 */
	public final Set<Team> getTeams()
	{
		final Set<Team> l=new HashSet<Team>();
		for (Match m:getMatchs())
		{
			l.add(m.getHomeTeam());
			l.add(m.getAwayTeam());
		}
		return l;
	}

	/**
	 * 
	 * @param homeTeamName
	 * @param awayTeamName
	 * @return
	 */
	public final Match getMatchWithTeamsNames(final String homeTeamName,final String awayTeamName) 
	{
		for (Match m:getMatchs())
		{
			if (m.getHomeTeam().getTeamName().equals(homeTeamName)
			    &&m.getAwayTeam().getTeamName().equals(awayTeamName)) return m;
		}
		return null;
	}	
}
