/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.doopyon.ravanelab.core.domain;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 *
 * Entity representing Team.
 * This class is responsible for the domain object related
 * business logic for Team. Properties and associations are
 * implemented in the generated base class {@link org.doopyon.ravanelab.core.domain.TeamBase}.
 */
@Entity
@Table(name = "TEAM")
@org.hibernate.annotations.Cache(usage = org.hibernate.annotations.CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Team extends TeamBase 
{
	//
	// Static fields
	//
	
	/** */
	private static final long serialVersionUID = 7717158790929074029L;

	
	//
	// Constructors
	//
	
	/**
	 * Constructor.
	 */
    protected Team() 
    {
    	super();
    }

	/**
	 * Constructor.
	 */    
    public Team(String teamName) 
    {
        super(teamName);
    }
    
    
    //
    // Instance methods
    //
    
	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String toString()
	{	
		return getTeamName();
	}    
}
