/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.core.serviceimpl;

import org.doopyon.ravanelab.core.domain.*;
import org.springframework.stereotype.*;


/**
 * Implementation of MatchEvaluatorService.
 * 
 * @author Olivier PARISOT
 */
@Service(MatchEvaluatorServiceImpl.BEAN_ID)
public class MatchEvaluatorServiceImpl extends MatchEvaluatorServiceImplBase 
{
    //
    // Instance methods
    //
    
    /**
     * {@inheritDoc}
     */    
    @Override
    public final MatchEvaluation getMatchEvaluation(final Match m) 
    {
    	if (m.getScore()==null) return MatchEvaluation.NOTPLAYED;    	
    		
    	final int homePoints=m.getScore().getHomePoints();
    	final int awayPoints=m.getScore().getAwayPoints();
    	if (homePoints>awayPoints) return MatchEvaluation.RESULT_1;
    	else if (homePoints<awayPoints) return MatchEvaluation.RESULT_2;
    	else return MatchEvaluation.RESULT_N;
    }	
}
