/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.datasource;

import java.util.*;


/**
 * Data provider factory.
 * 
 * @author Olivier PARISOT
 */
public final class ExternalLeagueDataPacketProviderFactory 
{
	//
	// Static fields
	//
	
	/** Bean id. */
	public static final String BEAN_ID="externalLeagueDataPacketProviderFactory";
	
	
	//
	// Instance fields
	//
	
	/** Data providers. */
	private List<ExternalLeagueDataPacketProvider> providers=new ArrayList<ExternalLeagueDataPacketProvider>(1);
	
			
	//
	// Instance methods
	//
	
	/**
	 * Set the data providers.
	 * @param providers the data providers to set
	 */
	public final void setProviders(final List<ExternalLeagueDataPacketProvider> providers) 
	{
		this.providers=providers;
	}	
	
	/**
	 * Get a data provider accepting a given league name.
	 * @param checkedLeagueName a given league name.
	 * @return the data provider if found, false otherwise
	 */
	public final ExternalLeagueDataPacketProvider getProvider(final String checkedLeagueName)
	{
		for (ExternalLeagueDataPacketProvider provider:providers)
		{
			if (provider.acceptLeagueName(checkedLeagueName)) return provider;
		}
		throw new IllegalStateException("No data provider registered for league '"+checkedLeagueName+"'");
	}
}
