/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.datasource;

import java.util.*;
import org.doopyon.ravanelab.etl.domain.*;


/**
 * 
 * 
 * @author Olivier PARISOT
 */
public abstract class ExternalLeagueDataPacketsListProvider implements Iterator<List<ExternalLeagueDataPacket>> 
{
	//
	// Instance fields
	//
	
	/** */
	protected final ExternalLeagueDataPacketProvider provider;
	/** */
	protected final int packetsListSize;
	
	
	//
	// Constructor
	//
	
	/**
	 * Constructor.
	 */
	public ExternalLeagueDataPacketsListProvider(ExternalLeagueDataPacketProvider provider,final int packetsListSize)
	{
		this.provider=provider;
		this.packetsListSize=packetsListSize;
	}
	
	
	//
	// Instance methods
	//
	
	/** 
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasNext() 
	{		
		return provider.hasNext();
	}

	/** 
	 * {@inheritDoc}
	 */
	@Override
	public void remove() 
	{
		provider.remove();		
	}

}
