/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.datasource;

import java.util.*;
import java.util.concurrent.*;
import org.doopyon.ravanelab.etl.domain.*;


/**
 * 
 * 
 * @author Olivier PARISOT
 */
public final class ParallelExternalLeagueDataPacketsListProvider extends ExternalLeagueDataPacketsListProvider 
{
	//
	// Static fields
	//
	
	/** */
	public static final int MAX_THREADS_COUNT=10;

	
	//
	// Constructor
	//
	
	/**
	 * Constructor.
	 */
	public ParallelExternalLeagueDataPacketsListProvider(ExternalLeagueDataPacketProvider provider,final int packetsListSize)
	{
		super(provider,packetsListSize);
	}
	
	
	//
	// Instance methods
	//
	
	/** 
	 * {@inheritDoc}
	 */
	@Override
	public List<ExternalLeagueDataPacket> next() 
	{
		final ExecutorService executor=Executors.newFixedThreadPool(MAX_THREADS_COUNT);		
		final List<Callable<ExternalLeagueDataPacket>> l=new ArrayList<Callable<ExternalLeagueDataPacket>>();		

		for (int i=0;i<packetsListSize;i++)
		{	
			final Callable<ExternalLeagueDataPacket> future=new Callable<ExternalLeagueDataPacket>() 
		    {
		           	public ExternalLeagueDataPacket call() 
		           	{		           		
		           		ExternalLeagueDataPacket r=null;
		           		try
		           		{
		           			//synchronized(provider)
		           			//{
		           			Thread.sleep((int)(1000*Math.random()));
		           			if (provider.hasNext()) r=provider.next();
		           			//}
		           		}
		           		catch(Exception e) {}
		           		return r;
		           	}
		    };
		    l.add(future);						
		}
		
		final List<ExternalLeagueDataPacket> list=new ArrayList<ExternalLeagueDataPacket>(packetsListSize);
		try 
		{
			final List<Future<ExternalLeagueDataPacket>> r=executor.invokeAll(l);
			for (Future<ExternalLeagueDataPacket> f:r)
			{
				final ExternalLeagueDataPacket eldp=f.get();
				if (eldp!=null) list.add(eldp);
			}			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return list;
	}	
}
