/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.datasource;

import java.util.*;
import org.doopyon.ravanelab.etl.domain.*;


/**
 * 
 * 
 * @author Olivier PARISOT
 */
public final class SimpleExternalLeagueDataPacketsListProvider extends ExternalLeagueDataPacketsListProvider 
{
	//
	// Constructor
	//
	
	/**
	 * Constructor.
	 */
	public SimpleExternalLeagueDataPacketsListProvider(ExternalLeagueDataPacketProvider provider,final int packetsListSize)
	{
		super(provider,packetsListSize);
	}
	
	
	//
	// Instance methods
	//

	/** 
	 * {@inheritDoc}
	 */
	@Override
	public List<ExternalLeagueDataPacket> next() 
	{
		final List<ExternalLeagueDataPacket> res=new ArrayList<ExternalLeagueDataPacket>(packetsListSize);
		for (int i=0;i<packetsListSize&&provider.hasNext();i++) res.add(provider.next());
		return res;
	}	
}
