/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 */
package org.doopyon.ravanelab.ext.serviceimpl;

import java.io.*;
import java.util.*;
import javax.annotation.*;
import org.apache.commons.logging.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.ext.serviceapi.*;
import au.com.bytecode.opencsv.*;


/**
 * Implementation of TeamInfosFinderService.
 * 
 * @author Olivier PARISOT
 */
public class TeamInfosFinderServiceByCSVFile implements TeamInfosFinderService
{
	//
	// Static fields
	//
	
	/** Logger. */
    private static final Log LOG=LogFactory.getLog(TeamInfosFinderServiceByCSVFile.class);	
    
    
	//
	// Instance fields
	//
	
	/** */
	private Map<String,Integer> map;
	
	
	//
	// Constructor
	//
	
	/**
	 * Constructor.
	 */
	public TeamInfosFinderServiceByCSVFile() 
	{
		map=new HashMap<String,Integer>();
	}

	
	//
	// Instance methods
	//
	
	/**
	 * 
	 */
	@PostConstruct
	public void init()
	{
		try
		{
			final CSVReader reader=new CSVReader(new FileReader("ravanelab-ext"+File.separatorChar+"budgets.csv"),',');
			String [] nextLine;
			while ((nextLine = reader.readNext()) != null) 
			{
				//System.out.println(StringUtil.concat(nextLine)+" "+nextLine.length);
				if (nextLine.length>=3) map.put(buildKey(nextLine[1].replaceAll("\'",""),Integer.valueOf(nextLine[0].trim())),Integer.valueOf(nextLine[2].trim()));
			}
		}
		catch(Exception e)
		{
			LOG.error("Error when loading data!",e);
		}		
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
    public int findBudgetByTeamAndSeasonYear(final Team team,final int seasonYear) 
    {
		final Integer i=map.get(buildKey(team.getTeamName(),seasonYear));
		if (i==null) return -1;
		else return i.intValue();
    }
    
    
	//
	// Static methods
	//
	
	/**
	 * 
	 * @param teamName
	 * @param seasonYear
	 * @return
	 */
	private static String buildKey(final String teamName,final int seasonYear)
	{
		return teamName+','+seasonYear;
	}
}
