/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.lab.serviceimpl;

import org.apache.commons.logging.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.ext.serviceapi.*;
import org.doopyon.ravanelab.lab.serviceapi.*;
import org.springframework.beans.factory.annotation.*;
import org.springframework.stereotype.*;
import java.util.*;


/**
 * Implementation of LogicMatchEvaluationComputerService.
 *
 * @author Olivier PARISOT
 */
@Service(LogicMatchEvaluationComputerServiceImpl.BEAN_ID)
public class LogicMatchEvaluationComputerServiceImpl implements LogicMatchEvaluationComputerService 
{
	//
	// Static fields
	//
	
	/** Logger. */
    private static final Log LOG=LogFactory.getLog(LogicMatchEvaluationComputerServiceImpl.class);	
	
	
	//
	// Instance fields
	//
	
	/** */
	private TeamInfosFinderService teamInfosFinderService;
	
	
	//
	// Instance methods
	//
	
	/**
	 * 
	 * @param teamInfosFinderService the teamInfosFinderService to set
	 */
	@Autowired
	public void setTeamInfosFinderService(final TeamInfosFinderService teamInfosFinderService) 
	{
		this.teamInfosFinderService=teamInfosFinderService;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public final Set<MatchEvaluation> getComputedLogicMatchEvaluations(final Match m,final LeagueSeasonRanking lsr) 
	{
		Set<MatchEvaluation> r=formatResult(MatchEvaluation.UNDEFINED);
		
		final Team homeTeam=m.getHomeTeam();
		final int homeRanking=lsr.getRankOfTeamByPoints(homeTeam);
		final int reversedHomeRanking=20-homeRanking;
		final int homeBudget=teamInfosFinderService.findBudgetByTeamAndSeasonYear(homeTeam,lsr.getSeasonYear());
		final Team awayTeam=m.getAwayTeam();
		final int awayRanking=lsr.getRankOfTeamByPoints(awayTeam);
		final int reversedAwayRanking=20-awayRanking;		
		final int awayBudget=teamInfosFinderService.findBudgetByTeamAndSeasonYear(awayTeam,lsr.getSeasonYear());

		if (homeBudget>awayBudget)
		{	
			if (reversedHomeRanking>reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_1);
			else if (reversedHomeRanking==reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_1);
			//else if (reversedHomeRanking==reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_1,MatchEvaluation.RESULT_N); // bof?
		}
		//else if (homeBudget==awayBudget)
		//{	
			//if (reversedHomeRanking==reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_N);
			//else if (reversedHomeRanking>reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_1,MatchEvaluation.RESULT_N);
			//else if (reversedHomeRanking<reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_N,MatchEvaluation.RESULT_2);
		//}
		else if (homeBudget<awayBudget)
		{	
			if (reversedHomeRanking<reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_2);
			//else if (reversedHomeRanking==reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_N,MatchEvaluation.RESULT_2); // bof? 
		}
		
		LOG.info("getComputedLogicMatchEvaluations -> match{"+m+"} home[budget="+homeBudget+",ranking="+homeRanking+"] away[budget="+awayBudget+",ranking="+awayRanking+"] -> "+r);
		
		return r;
	}

	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public final Set<MatchEvaluation> getComputedNotLogicMatchEvaluations(final Match m,final LeagueSeasonRanking lsr) 
	{
		Set<MatchEvaluation> r=formatResult(MatchEvaluation.UNDEFINED);
		
		final Team homeTeam=m.getHomeTeam();
		final int homeRanking=lsr.getRankOfTeamByPoints(homeTeam);
		final int reversedHomeRanking=20-homeRanking;
		final int homeBudget=teamInfosFinderService.findBudgetByTeamAndSeasonYear(homeTeam,lsr.getSeasonYear());
		final Team awayTeam=m.getAwayTeam();
		final int awayRanking=lsr.getRankOfTeamByPoints(awayTeam);
		final int reversedAwayRanking=20-awayRanking;		
		final int awayBudget=teamInfosFinderService.findBudgetByTeamAndSeasonYear(awayTeam,lsr.getSeasonYear());

		if (homeBudget>awayBudget)
		{	
			if (reversedHomeRanking>reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_N,MatchEvaluation.RESULT_2);
			else if (reversedHomeRanking==reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_2); // bof?
		}
		//else if (homeBudget==awayBudget)
		//{	
		//	if (reversedHomeRanking>reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_2);
		//	else if (reversedHomeRanking<reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_2);
		//}
		else if (homeBudget<awayBudget)
		{	
			if (reversedHomeRanking<reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_1/*,MatchEvaluation.RESULT_N*/);
			//else if (reversedHomeRanking==reversedAwayRanking) r=formatResult(MatchEvaluation.RESULT_1); // bof? 
		}
		
		LOG.info("getComputedNotLogicMatchEvaluations -> match{"+m+"} home[budget="+homeBudget+",ranking="+homeRanking+"] away[budget="+awayBudget+",ranking="+awayRanking+"] -> "+r);
		
		return r;
	}
	
	//
	// Static methods
	//
	
	/**
	 * Build a set from a given array of MatchEvaluations.
	 * @return a given array of MatchEvaluations
	 */
	private static final Set<MatchEvaluation> formatResult(final MatchEvaluation... me)
	{
		return new HashSet<MatchEvaluation>(Arrays.asList(me));
	}


}
