/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.doopyon.ravanelab.nn.domain;

import org.doopyon.ravanelab.util.*;


/**
 *
 * Value object representing NeuralNetworksAggregate.
 * This class is responsible for the domain object related
 * business logic for NeuralNetworksAggregate. Properties and associations are
 * implemented in the generated base class {@link NeuralNetworksAggregateBase}.
 */
public class NeuralNetworksAggregate extends NeuralNetworksAggregateBase 
{
	//
	// Static fields
	//
	
	/** Serial version UID. */
	private static final long serialVersionUID=6068994469673617243L;

	
	//
	// Constructors
	//
	
	/**
	 * Constructor.
	 */
    public NeuralNetworksAggregate() 
    {
    	super();
    }

    /**
     * Constructor.
     * @param bestNeuralNetwork
     */
    public NeuralNetworksAggregate(final NeuralNetwork bestNeuralNetwork) 
    {
        super(bestNeuralNetwork);
    }
    
    
    //
    // Instance methods
    //
    
    /**
     * 
     */
    public final NeuralNetworkData computeUsingBestNeuralNetwork(final NeuralNetworkData input)
    {
    	if (getBestNeuralNetwork()==null) throw new IllegalStateException("No best neural network for this aggregate?");
    	return getBestNeuralNetwork().compute(input); 
    }
    
    /**
     * 
     */
    public final NeuralNetworkData computeAverageUsingAllNeuralNetworks(final NeuralNetworkData input)
    {
    	if (getNeuralNetworks()==null) throw new IllegalStateException("No neural networks list for this aggregate?");
    	
		final Repartition<NeuralNetworkData> rep=new Repartition<NeuralNetworkData>();
		for (NeuralNetwork nn:getNeuralNetworks()) rep.addOccurenceFor(nn.compute(input));						
		return rep.getTheMostOccurred();
    }
}
