/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.nn.domain.util;

import java.util.*;

import org.doopyon.ravanelab.nn.domain.NeuralNetwork;


/**
 * Neural network comparator: use the neurons count for comparison.
 * 
 * @author Olivier PARISOT
 */
public final class NeuralNetworkComparator implements Comparator<NeuralNetwork> 
{
	//
	// Instance methods
	//
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public int compare(final NeuralNetwork nn1,final NeuralNetwork nn2) 
	{
		return -(nn1.getInputNeuronsCount()+nn1.getOutputNeuronsCount()+nn1.getHiddenNeuronsCount())
				+(nn2.getInputNeuronsCount()+nn2.getOutputNeuronsCount()+nn2.getHiddenNeuronsCount());
	}

}
