/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 */
package org.doopyon.ravanelab.prediction.serviceimpl;

import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.prediction.domain.*;
import org.springframework.stereotype.*;


/**
 * Implementation of MatchPredictionBuilderService.
 * 
 * @author Olivier PARISOT
 */
@Service(MatchPredictionBuilderServiceImpl.BEAN_ID)
public class MatchPredictionBuilderServiceImpl extends MatchPredictionBuilderServiceImplBase 
{
	//
	// Instance methods
	//

    /**
     * {@inheritDoc}
     */
	@Override
    public final MatchEvaluation getMatchPrediction(final MatchPredictionContext matchPredictionContext,final MatchPredictionStrategy matchPredictionStrategy,final Match m,final LeagueSeasonRanking ranking) 
    {
		if (matchPredictionStrategy.equals(MatchPredictionStrategy.ONLY_THE_BEST))
		{		
			return getMatchEvaluationCodecService().getDecodedMatchEvaluation(matchPredictionContext.getNeuralNetworksAggregate().computeUsingBestNeuralNetwork(getMatchCodecService().getEncodedMatch(m,ranking)));
		}
		else if (matchPredictionStrategy.equals(MatchPredictionStrategy.AVERAGE_RESULTS))
		{
			return getMatchEvaluationCodecService().getDecodedMatchEvaluation(matchPredictionContext.getNeuralNetworksAggregate().computeAverageUsingAllNeuralNetworks(getMatchCodecService().getEncodedMatch(m,ranking)));

		}
		else throw new IllegalStateException("Unknown match prediction strategy -> "+matchPredictionStrategy);			
    }
}
