/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 */
package org.doopyon.ravanelab.prediction.serviceimpl;

import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.prediction.domain.*;
import org.doopyon.ravanelab.prediction.serviceapi.MatchPredictionBuilderService;
import org.springframework.stereotype.*;
import java.util.*;


/**
 * Implementation of MatchPredictionFacadeService.
 * 
 * @author Olivier PARISOT
 */
@Service(MatchPredictionFacadeServiceImpl.BEAN_ID)
public class MatchPredictionFacadeServiceImpl extends MatchPredictionFacadeServiceImplBase 
{
	//
	// Static fields
	//
	
	/** Count of years to be used to built prediction context. */
	private static final int NB_YEARS=20;
	
	
	//
	// Instance methods
	//
	
	/**
	 * {@inheritDoc}
	 */
 	@Override
    public final List<MatchPrediction> getMatchWeekPrediction(final String leagueName,final int seasonYear,final int matchWeekOrder) 
    {
 		/* check argument and retrieve needed objects */
 		final League l=getLeagueService().findLeagueByName(leagueName);
 		if (l==null) throw new IllegalArgumentException("League '"+leagueName+"' not found!"); 		
 		
 		/* build prediction context */
 		final MatchPredictionContext mpc=getMatchPredictionContextBuilderService().getMatchPredictionContext(l,seasonYear-NB_YEARS,1,seasonYear,matchWeekOrder-1);
 		if (mpc==null) throw new IllegalStateException("Impossible to build a match prediction context?");
 		
 		/* compute predictions for each match of the matchweek and each strategy */
 		final LeagueSeason ls=l.getLeagueSeasonForYear(seasonYear);
 		if (ls==null) throw new IllegalArgumentException("League season '"+seasonYear+"' not found for league '"+leagueName+"'! -> details: ..."); 		 		
 		final MatchWeek mw=ls.getMatchWeek(matchWeekOrder);
 		if (mw==null) throw new IllegalArgumentException("Match week '"+matchWeekOrder+"' not found for league '"+leagueName+"' and season='"+seasonYear+"' [available matchs weeks: "+ls.getAvailableMathWeeksOrders()+"]");		
 		
 		final List<MatchPrediction> res=new ArrayList<MatchPrediction>();
		final LeagueSeasonRanking ranking=getLeagueSeasonRankingService().getLeagueSeasonRanking(l,seasonYear,matchWeekOrder-1);	
		
		final MatchPredictionBuilderService matchPredictionBuilderService=getMatchPredictionBuilderService();
 		for (Match m:mw.getMatchs())
 		{
 			for (MatchPredictionStrategy strategy:MatchPredictionStrategy.values())
 			{ 				
				final MatchEvaluation eval=matchPredictionBuilderService.getMatchPrediction(mpc,strategy,m,ranking);
 				res.add(new MatchPrediction(m.getHomeTeam(),m.getAwayTeam(),eval));
 			}
 		}
 		
		return res;    
	}
}
