/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.util;

import java.util.*;


/**
 * Maths utility class.
 * 
 * @author Olivier PARISOT
 */
public final class MathsUtil 
{
	//
	// Static fields
	//
	
	/** */
	private static final double DOUBLE_ERROR=0.00001d;
	
	
	//
	// Constructor
	//
	
	/**
	 * Private constructor to avoid instanciation.
	 */
	private MathsUtil() {}
	
	
	//
	// Static methods
	//
	
	/**
	 * 
	 * @param number
	 * @param sum
	 * @return
	 */
	public static double normalizeAndRound(final double number,final double sum)
	{
		return Math.round((number*100d)/sum)/100d;
	}
	
	/**
	 * 
	 * @param tab
	 */
	public static int getIndexOfMinValue(final double[] tab)
	{
		if (tab==null) throw new IllegalArgumentException("getIndexOfMinValue(): The array should not be null!");
		if (tab.length==0) throw new IllegalArgumentException("getIndexOfMinValue(): The array should not be empty!");
		
		int idxOfMin=-1;
		double currentMin=Double.MAX_VALUE;
		for (int i=0;i<tab.length;i++)
		{
			if (tab[i]<currentMin)
			{
				idxOfMin=i;
				currentMin=tab[i];
			}
		}
		return idxOfMin;
	}
	
	/**
	 * 
	 * @param tab
	 */
	public static int getIndexOfMaxValue(final double[] tab)
	{
		if (tab==null) throw new IllegalArgumentException("getIndexOfMaxValue(): The array should not be null!");
		if (tab.length==0) throw new IllegalArgumentException("getIndexOfMaxValue(): The array should not be empty!");
		
		int idxOfMax=-1;
		double currentMax=Double.MIN_VALUE;
		for (int i=0;i<tab.length;i++)
		{
			if (tab[i]>currentMax)
			{
				idxOfMax=i;
				currentMax=tab[i];
			}
		}
		return idxOfMax;
	}
	
	/**
	 * Get the max value of a given collection of Integers.
	 * @param c a given collection of Integers
	 * @return the max value
	 */
	public static int getMaxValue(final Collection<Integer> c)
	{	
		if (c==null) throw new IllegalArgumentException("getMaxValue(): The collection should not be null!");
		if (c.size()==0) throw new IllegalArgumentException("getMaxValue(): The collection should not be empty!");
		
		int currentMax=Integer.MIN_VALUE;
		for (Iterator<Integer> iter=c.iterator();iter.hasNext();)
		{
			final int v=iter.next();
			if (v>currentMax) currentMax=v;			
		}
		return currentMax;
	}
	
	/**
	 * Compute the sum of a given array of doubles.
	 * @param tab a given array of doubles
	 * @return the sum
	 */
	public static double sum(final double[] tab)
	{
		double sum=0d;
		for (double d:tab) sum+=d; 
		return sum;
	}
	
	/**
	 * Check if two doubles are equals (according to an erreor rate).
	 * Should be always used instead of d1==d2!!!! 
	 * @param d1 the first double to check
	 * @param d2 the second double to check
	 */
	public static boolean areTheSame(final double d1,final double d2)
	{
		return Math.abs(d1-d2)<DOUBLE_ERROR;
	}
}
