/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.util.encoding.serviceapi;

import java.util.*;


/**
 * Encoding strategy interface.
 * 
 * @author Olivier PARISOT
 */
public interface EncodingStrategy 
{
	//
	// Static fields
	//
	
	/** Bean id. */
    static final String BEAN_ID="encodingStrategy";
    
	
	//
	// Instance methods
	//
	
	/**
	 * Encode an integer to a list of doubles.
	 * @param val the integer to encode
	 * @param maxValue the max value of this integer
	 * @return the list of doubles
	 */
	List<Double> getEncodedInt(final int val,final int maxValue);

}