/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.util.encoding.serviceimpl;

import java.util.*;


/**
 * BinaryEncodingStrategy.
 * 
 * @author Olivier PARISOT
 */
public final class BinaryEncodingStrategy extends EncodingStrategyImplBase 
{
	//
	// Instance methods
	//
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<Double> getEncodedInt0(final int val,final int maxValue) 
	{
		/* compute size */
		int size=0;
		int tmpMax=maxValue;
		while (tmpMax>0)
		{
			tmpMax=tmpMax/2;
			size++;
		}		
		
		/* fill results */
		final List<Double> res=new ArrayList<Double>(size);		
		int currentValue=val;
		while (currentValue>0)
		{
			res.add((double)(currentValue%2));
			currentValue=currentValue/2;			
		}
		if (res.size()>size)
		{
			throw new IllegalStateException("Error in encodeInt0() -> res.size()>size");
		}
		else
		{
			while (res.size()!=size) res.add(0d);
		}
		return res;
	}

}
