/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.util.encoding.serviceimpl;

import java.util.*;


/**
 * Fake encoding strategy.
 * 
 * @author Olivier PARISOT
 */
public final class FakeEncodingStrategy extends EncodingStrategyImplBase 
{
	//
	// Instance methods
	//
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public final List<Double> getEncodedInt0(final int val,final int maxValue) 
	{
		final List<Double> res=new ArrayList<Double>(1);		
		res.add(Double.valueOf(val%2));		
		return res;
	}

}
