/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.codec.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.core.serviceapi.*;
import org.doopyon.ravanelab.helpers.serviceapi.*;
import org.doopyon.ravanelab.nn.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * @author Olivier PARISOT
 */
public class MatchCodecServiceTest extends AbstractDbUnitJpaTests implements MatchCodecServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private MatchCodecService matchCodecService;
	/** */
    private FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService;
	/** */
    private LeagueSeasonRankingService leagueSeasonRankingService;
    
    
    //
    // Instance methods
    //
    
    @Autowired
    public void setMatchCodecService(MatchCodecService matchCodecService) 
    {
        this.matchCodecService=matchCodecService;
    }

    @Autowired
    public void setFakeLeagueSeasonBuilderService(FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService) 
    {
        this.fakeLeagueSeasonManagerService=fakeLeagueSeasonManagerService;
    }      
    
    @Autowired
    public void setLeagueRankingService(LeagueSeasonRankingService leagueRankingService) 
    {	
        this.leagueSeasonRankingService=leagueRankingService;
    }        
    
    @Test
    public void testGetEncodedMatch() throws Exception 
    {
    	final Set<Team> teams=new HashSet<Team>();
    	teams.add(new Team("aa"));
    	teams.add(new Team("bb"));
    	teams.add(new Team("cc"));
    	teams.add(new Team("dd")); 		
		final League league=new League("Fake");
		final LeagueSeason leagueSeason=fakeLeagueSeasonManagerService.buildFakeLeagueSeason(2009,teams);
		league.addLeagueSeason(leagueSeason);

		final Match match=leagueSeason.getMatchWeek(4).getMatchs().iterator().next();
		
		final LeagueSeasonRanking lsr=leagueSeasonRankingService.getLeagueSeasonRanking(league,leagueSeason.getSeasonYear(),3);;		
		
		final NeuralNetworkData nnd=matchCodecService.getEncodedMatch(match,lsr);
		
		assertNotNull(nnd);
		assertNotSame(nnd.size(),0);
    }
}
