/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.codec.serviceapi;

import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.nn.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * @author Olivier PARISOT
 */
public class MatchEvaluationCodecServiceTest extends AbstractDbUnitJpaTests implements MatchEvaluationCodecServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private MatchEvaluationCodecService codecService;

    
    //
    // Instance methods
    //    
    
    @Autowired
    public void setMatchEvaluationCodecService(MatchEvaluationCodecService matchEvaluationCodecService) 
    {
        this.codecService=matchEvaluationCodecService;        
    }

    @Test
    @Override
    public void testGetEncodedMatchEvaluation() throws Exception 
    {    	
    	final NeuralNetworkData e1=codecService.getEncodedMatchEvaluation(MatchEvaluation.RESULT_1);    	
    	assertNotNull(e1);
    	final NeuralNetworkData eN=codecService.getEncodedMatchEvaluation(MatchEvaluation.RESULT_N);    	
    	assertNotNull(eN);
    	final NeuralNetworkData e2=codecService.getEncodedMatchEvaluation(MatchEvaluation.RESULT_2);    	
    	assertNotNull(e2);
    }

    @Test
    @Override    
    public void testGetDecodedMatchEvaluation() throws Exception {}
    
    @Test
    public void testBijectiveEncoding()
    {
    	final MatchEvaluation r1=codecService.getDecodedMatchEvaluation(codecService.getEncodedMatchEvaluation(MatchEvaluation.RESULT_1));
    	assertEquals(MatchEvaluation.RESULT_1,r1);
    	final MatchEvaluation rN=codecService.getDecodedMatchEvaluation(codecService.getEncodedMatchEvaluation(MatchEvaluation.RESULT_N));
    	assertEquals(MatchEvaluation.RESULT_N,rN);
    	final MatchEvaluation r2=codecService.getDecodedMatchEvaluation(codecService.getEncodedMatchEvaluation(MatchEvaluation.RESULT_2));
    	assertEquals(MatchEvaluation.RESULT_2,r2);    
    }
}
