/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.codec.serviceimpl;

import static org.junit.Assert.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.nn.domain.*;
import org.junit.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * @author Olivier PARISOT
 */
public class MatchEvaluationCodecServiceModeTest
{
    @Test
    public void testMatchEvaluationCodecServiceModeALL() throws Exception 
    {   
    	final NeuralNetworkData nnd1=MatchEvaluationCodecServiceMode.ALL.getEncodedMatchEvaluation(MatchEvaluation.RESULT_1);    	
    	assertEquals(nnd1.get(0),1d,0.000001d);
    	assertEquals(nnd1.get(1),0d,0.000001d);
    	assertEquals(nnd1.get(2),0d,0.000001d);

    	final NeuralNetworkData nndN=MatchEvaluationCodecServiceMode.ALL.getEncodedMatchEvaluation(MatchEvaluation.RESULT_N);    	
    	assertEquals(nndN.get(0),0d,0.000001d);
    	assertEquals(nndN.get(1),1d,0.000001d);
    	assertEquals(nndN.get(2),0d,0.000001d);
    	
    	final NeuralNetworkData nnd2=MatchEvaluationCodecServiceMode.ALL.getEncodedMatchEvaluation(MatchEvaluation.RESULT_2);    	
    	assertEquals(nnd2.get(0),0d,0.000001d);
    	assertEquals(nnd2.get(1),0d,0.000001d);
    	assertEquals(nnd2.get(2),1d,0.000001d);
    }

    @Test    
    public void testGetDecodedMatchEvaluation() throws Exception 
    {
    	final NeuralNetworkData nnd1=new NeuralNetworkData(0.7d,0.1d,0.2d);    	
    	assertEquals(MatchEvaluation.RESULT_1,MatchEvaluationCodecServiceMode.ALL.getDecodedMatchEvaluation(nnd1));
    	final NeuralNetworkData nndN=new NeuralNetworkData(0.3d,0.9d,0.2d);
    	assertEquals(MatchEvaluation.RESULT_N,MatchEvaluationCodecServiceMode.ALL.getDecodedMatchEvaluation(nndN));
    	final NeuralNetworkData nnd2=new NeuralNetworkData(0.1d,0.4d,0.8d);
    	assertEquals(MatchEvaluation.RESULT_2,MatchEvaluationCodecServiceMode.ALL.getDecodedMatchEvaluation(nnd2));
    }
}
