/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.core.domain.tests;

import java.util.*;
import java.util.concurrent.atomic.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.helpers.serviceapi.*;


/**
 * Utility class to be used for testing purpose only.
 * 
 * @author Olivier PARISOT
 */
public final class LeagueSeasonTestUtil 
{
	//
	// Static fields
	//
	
	/** Static counter used to build identifiers. */
	private static AtomicInteger INTERNAL_COUNTER=new AtomicInteger(0);

	/** */
	public static final int MAX_YEAR=2010;
	/** */
	public static final int MIN_YEAR=1990;	
	/** */
	public static final int NB_TEAMS=4;
	/** */
	public static final int NB_MATCHWEEK_PER_SEASON=2*(NB_TEAMS-1);
	
	
	//
	// Conctructor
	//
	
	/**
	 * Private constructor to avoid instanciation. 
	 */
	private LeagueSeasonTestUtil(){}
	
		
	//
	// Static methods
	//
	
	/**
	 * Build a fake league, with fake data; to be used for testing purpose only.
	 * @param fakeLeagueSeasonManagerService 
	 * @return the fake league built
	 */
	public static final League buildLeagueForTesting(final FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService)
	{
    	final Set<Team> teams=buildTeamsForTesting(NB_TEAMS);		
		final League league=new League("FakeLeague"+INTERNAL_COUNTER.incrementAndGet());
		for (int year=MIN_YEAR;year<MAX_YEAR;year++)
		{
			final LeagueSeason ls=fakeLeagueSeasonManagerService.buildFakeLeagueSeason(year,teams);
			fakeLeagueSeasonManagerService.simulateLeagueSeason(ls,NB_MATCHWEEK_PER_SEASON);
			league.addLeagueSeason(ls);
		}
		league.addLeagueSeason(fakeLeagueSeasonManagerService.buildFakeLeagueSeason(MAX_YEAR,teams));
		return league;
	}
	
	/**
	 * Build a list of fake teams; to be used for testing purpose only.
	 * @return a list of fake teams
	 */
	public static final Set<Team> buildTeamsForTesting(final int size)
	{
    	final Set<Team> teams=new HashSet<Team>(size);
    	for (int i=0;i<size;i++) teams.add(new Team("FakeTeam"+INTERNAL_COUNTER.incrementAndGet()));	
    	return teams;
	}
}
