/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.core.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.core.domain.tests.*;
import org.doopyon.ravanelab.helpers.serviceapi.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class LeagueSeasonRankingServiceTest extends AbstractDbUnitJpaTests implements LeagueSeasonRankingServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private LeagueSeasonRankingService leagueSeasonRankingService;
	/** */
    private FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService;    
    
    
    //
    // Instance methods
    //
    
    @Autowired
    public void setLeagueRankingService(LeagueSeasonRankingService leagueRankingService) 
    {	
        this.leagueSeasonRankingService=leagueRankingService;
    }

    @Autowired
	public void setFakeLeagueSeasonBuilderService(FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService) 
	{
		this.fakeLeagueSeasonManagerService=fakeLeagueSeasonManagerService;
	}    
    
    @Test
    public void testGetLeagueSeasonRanking() throws Exception 
    {
    	final int seasonYear=2009;
    	
		final League league=LeagueSeasonTestUtil.buildLeagueForTesting(fakeLeagueSeasonManagerService);    	
    	final Set<Team> teams=league.getLeagueSeasonForYear(seasonYear).getTeams();
		
    	final LeagueSeasonRanking lsr=leagueSeasonRankingService.getLeagueSeasonRanking(league,seasonYear,4);
    	assertNotNull(lsr);
    	assertEquals(teams.size(),lsr.getLeagueSeasonRankingByTeams().size());
    	
		final int nbMatchWeeks=2*(teams.size()-1);
    	for (LeagueSeasonRankingByTeam lsrbt:lsr.getLeagueSeasonRankingByTeams())
    	{
    		assertTrue(lsrbt.getTotalCountOfPlayedMatchs()<=nbMatchWeeks);
    	}
    }


}
