/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.core.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.core.domain.tests.*;
import org.doopyon.ravanelab.helpers.serviceapi.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class LeagueServiceTest extends AbstractDbUnitJpaTests implements LeagueServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private LeagueService leagueService;
	/** */
    private FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService;   
    
    
    //
    // Instance methods
    //

    @Autowired
	public void setFakeLeagueSeasonBuilderService(FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService) 
	{
		this.fakeLeagueSeasonManagerService=fakeLeagueSeasonManagerService;
	}       
    
    @Autowired
    public void setLeagueService(LeagueService leagueService) 
    {
        this.leagueService=leagueService;
    }

    @Test
    @Override 
    public void testFindAll() throws Exception 
    {
    	final List<League> ll=leagueService.findAll();
    	assertNotNull(ll);
    	assertTrue(ll.size()>0);
    }

    @Test
    @Override 
    public void testSave() throws Exception 
    {
    	final League l=leagueService.findLeagueByName("Ligue1");
    	assertNotNull(l);
    	
    	final LeagueSeason ls=new LeagueSeason(2007);    	
    	l.addLeagueSeason(ls);
    	
    	final MatchWeek mw=new MatchWeek(1);
    	ls.addMatchWeek(mw);    	
    	mw.setMatchWeekDay(Calendar.getInstance().getTime());
    	
    	leagueService.save(l);
    }

    @Test
    public void testSaveFake() throws Exception 
    {
    	final League l=LeagueSeasonTestUtil.buildLeagueForTesting(fakeLeagueSeasonManagerService);    	
    	leagueService.save(l);
    }        
    
    @Test
    @Override 
    public void testDelete() throws Exception 
    {
    	final League l=leagueService.findLeagueByName("SerieA");
    	assertNotNull(l);
    	
    	leagueService.delete(l);
    }

    @Test
	@Override
	public void testFindLeagueByName() throws Exception 
	{
    	final League leagueToFind=leagueService.findLeagueByName("Ligue1");
    	assertNotNull(leagueToFind);
    	assertEquals("Ligue1",leagueToFind.getLeagueName());
    }

    @Test    
	@Override
	public void testMerge() throws Exception 
	{
    	final League leagueToFind=leagueService.findLeagueByName("Ligue1");
    	assertNotNull(leagueToFind); 	
    	leagueToFind.addLeagueSeason(new LeagueSeason(1980));
    	leagueService.merge(leagueToFind);
	}
}
