/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.core.serviceapi;

import org.doopyon.ravanelab.core.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 */
public class MatchEvaluatorServiceTest extends AbstractDbUnitJpaTests implements MatchEvaluatorServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private MatchEvaluatorService matchEvaluatorService;

    
    //
    // Instance methods
    //
    
    @Autowired
    public void setMatchEvaluatorService(MatchEvaluatorService matchEvaluatorService) 
    {
        this.matchEvaluatorService=matchEvaluatorService;
    }   

    @Test
    public void testGetMatchEvaluation() throws Exception 
    {
    	final Match match1=new Match();
    	match1.setScore(new Score(5,0));
    	final Match matchN=new Match();
    	matchN.setScore(new Score(5,5));
    	final Match match2=new Match();
    	match2.setScore(new Score(0,5));
    	final Match matchNOTPLAYED=new Match();
    	
    	assertEquals(matchEvaluatorService.getMatchEvaluation(match1),MatchEvaluation.RESULT_1);
    	assertEquals(matchEvaluatorService.getMatchEvaluation(matchN),MatchEvaluation.RESULT_N);
    	assertEquals(matchEvaluatorService.getMatchEvaluation(match2),MatchEvaluation.RESULT_2);
    	assertEquals(matchEvaluatorService.getMatchEvaluation(matchNOTPLAYED),MatchEvaluation.NOTPLAYED);
    }
}
