/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.core.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.core.domain.tests.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class TeamServiceTest extends AbstractDbUnitJpaTests implements TeamServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private TeamService teamService;

    
    //
    // Instance methods
    //
    
    @Autowired
    public void setTeamService(TeamService teamService) 
    {
        this.teamService=teamService;
    }

    @Test
    @Override    
    public void testFindAll() throws Exception 
    {
        final List<Team> lt=teamService.findAll();
        assertNotNull(lt);
    	assertTrue(lt.size()>0);        
    }

    @Test
    @Override    
    public void testSave() throws Exception 
    {
    	assertNotNull(teamService.save(new Team("Boulogne Cte d'Opale")));
    }

    @Test   
    public void testSaveFake() throws Exception 
    {
    	for (Team t:LeagueSeasonTestUtil.buildTeamsForTesting(10))
    	{
    		assertNotNull(teamService.save(t));
    	}
    }    
    
    @Test
    @Override    
    public void testDelete() throws Exception 
    {
    	final Team teamToDelete=teamService.save(new Team("FCMetz"));
    	assertNotNull(teamToDelete);
    	teamService.delete(teamToDelete);
    }

    @Test
    @Override    
	public void testFindTeamByName() throws Exception 
	{
    	final Team teamToFind=teamService.findTeamByName("OL");
    	assertNotNull(teamToFind);
    	assertEquals("OL",teamToFind.getTeamName());
    	
    	//final Team teamToFind2=teamService.findTeamByName("Boulogne Cte d'Opale");
	}

    @Test
	@Override
	public void testMerge() throws Exception 
	{
    	final Team teamToFind=teamService.findTeamByName("OL");
    	assertNotNull(teamToFind);
    	teamService.merge(teamToFind);
    }
}
