/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.etl.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.etl.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class ExternalLeagueDataPacketImporterServiceTest extends AbstractDbUnitJpaTests implements ExternalLeagueDataPacketImporterServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private ExternalLeagueDataPacketImporterService externalLeagueDataPacketImporterService;

    
    //
    // Instance methods
    //
    
    @Autowired
    public void setExternalLeagueDataPacketImporterService(ExternalLeagueDataPacketImporterService externalLeagueDataPacketImporterService) 
    {
        this.externalLeagueDataPacketImporterService=externalLeagueDataPacketImporterService;
    }

    @Test
    @Override
    public void testImportExternalLeagueDataPacket() throws Exception 
    {
    	final ExternalLeagueDataPacket pckt=new ExternalLeagueDataPacket("SuperLeague",2009,1);
    	pckt.addExternalLeagueDataList(new ExternalLeagueData("FirstTeam","SecondTeam",3,2));
    	pckt.addExternalLeagueDataList(new ExternalLeagueData("ThirdTeam","FourthTeam'",0,0));
    	externalLeagueDataPacketImporterService.importExternalLeagueDataPacket(pckt);
    }

    @Test
    @Override
    public void testImportExternalLeagueDataPacketsList() throws Exception 
    {
    	final ExternalLeagueDataPacket pckt1=new ExternalLeagueDataPacket("SuperLeague1",2009,1);
    	pckt1.addExternalLeagueDataList(new ExternalLeagueData("FirstTeam1","SecondTeam1",3,2));
    	pckt1.addExternalLeagueDataList(new ExternalLeagueData("ThirdTeam1","FourthTeam1",0,0));
    	final ExternalLeagueDataPacket pckt2=new ExternalLeagueDataPacket("SuperLeague2",2009,1);
    	pckt2.addExternalLeagueDataList(new ExternalLeagueData("FirstTeam2'","SecondTeam2",3,2));
    	pckt2.addExternalLeagueDataList(new ExternalLeagueData("ThirdTeam2","FourthTeam2",0,0));    	
    	final List<ExternalLeagueDataPacket> list=new ArrayList<ExternalLeagueDataPacket>();
    	list.add(pckt1);
    	list.add(pckt2);
		externalLeagueDataPacketImporterService.importExternalLeagueDataPacketsList(list);
    }    
    
    @Test
    public void testImportExternalLeagueDataPacketWithKnownLeague() throws Exception 
    {
    	final ExternalLeagueDataPacket pckt=new ExternalLeagueDataPacket("Ligue1",1980,1);
    	pckt.addExternalLeagueDataList(new ExternalLeagueData("OL","PSG",3,2));
    	pckt.addExternalLeagueDataList(new ExternalLeagueData("ASM","OM",0,0));
    	externalLeagueDataPacketImporterService.importExternalLeagueDataPacket(pckt);
    	
    	final ExternalLeagueDataPacket pckt2=new ExternalLeagueDataPacket("Ligue1",1980,2);
    	pckt2.addExternalLeagueDataList(new ExternalLeagueData("OM","PSG",3,2));
    	pckt2.addExternalLeagueDataList(new ExternalLeagueData("ASM","OL",0,0));
    	externalLeagueDataPacketImporterService.importExternalLeagueDataPacket(pckt2);
    }
}
