/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.helpers.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.core.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class FakeLeagueSeasonManagerServiceTest extends AbstractDbUnitJpaTests implements FakeLeagueSeasonManagerServiceTestBase 
{
	//
	// Instance methods
	//
	
	/** */
    private FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService;

    
    //
    // Instance fields
    //
    
    @Autowired
    public void setFakeLeagueSeasonManagerService(FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService) 
    {
        this.fakeLeagueSeasonManagerService=fakeLeagueSeasonManagerService;
    }

	@Test
	public void testBuildFakeLeagueSeason() throws Exception 
	{
    	final Set<Team> teams=new HashSet<Team>(4);
    	teams.add(new Team("FC Metz"));
    	teams.add(new Team("ASNL"));
    	teams.add(new Team("GdB"));
    	teams.add(new Team("OL"));    	
    	final LeagueSeason ls=fakeLeagueSeasonManagerService.buildFakeLeagueSeason(2009,teams);
    	assertNotNull(ls);
    	assertEquals(ls.getMatchWeeks().size(),6);
	}

	@Test
	public void testSimulateLeagueSeason() throws Exception 
	{
    	final Set<Team> teams=new HashSet<Team>(4);
    	teams.add(new Team("FC Metz"));
    	teams.add(new Team("ASNL"));
    	teams.add(new Team("GdB"));
    	teams.add(new Team("OL"));    	
    	final LeagueSeason ls=fakeLeagueSeasonManagerService.buildFakeLeagueSeason(2009,teams);
    	
    	fakeLeagueSeasonManagerService.simulateLeagueSeason(ls,5);
		
	}
}
