/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.nn.domain;

import java.util.*;

import org.doopyon.ravanelab.nn.serviceapi.*;
import org.doopyon.ravanelab.nn.training.serviceimpl.RPNeuralNetworkTrainingStrategy;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * 
 * 
 * @author Olivier PARISOT
 */
public class NeuralNetworkTest extends AbstractDbUnitJpaTests 
{
	//
	// Instance fields
	//

	/** */
    private NeuralNetworkBuilderService neuralNetworkBuilderService;    

    
    //
    // Instance methods
    //

    @Autowired
	public void setNeuralNetworkBuilderService(NeuralNetworkBuilderService neuralNetworkBuilderService) 
	{
		this.neuralNetworkBuilderService=neuralNetworkBuilderService;
	}  
	
	@Test
	public void testCompute() throws Exception 
	{
		final NeuralNetwork nn=neuralNetworkBuilderService.getNeuralNetwork(3,1,4,0);
		final NeuralNetworkData input=new NeuralNetworkData(1d,0d,0d);
		final NeuralNetworkData output=nn.compute(input);
		assertNotNull(output);
		assertEquals(output.size(),1);
	}

    @Test
	public void testTrain() throws Exception 
	{
    	try
    	{
			final NeuralNetwork nn=neuralNetworkBuilderService.getNeuralNetwork(2,1,3,0);

			final List<NeuralNetworkData> inputs=new ArrayList<NeuralNetworkData>();
			inputs.add(new NeuralNetworkData(0d,0d));
			inputs.add(new NeuralNetworkData(0d,1d));
			inputs.add(new NeuralNetworkData(1d,0d));
			inputs.add(new NeuralNetworkData(1d,1d));
			inputs.add(new NeuralNetworkData(0d,0d));
			inputs.add(new NeuralNetworkData(0d,1d));
			inputs.add(new NeuralNetworkData(1d,0d));
			inputs.add(new NeuralNetworkData(1d,1d));
			inputs.add(new NeuralNetworkData(0d,0d));
			inputs.add(new NeuralNetworkData(0d,1d));
			inputs.add(new NeuralNetworkData(1d,0d));
			inputs.add(new NeuralNetworkData(1d,1d));
			inputs.add(new NeuralNetworkData(0d,0d));
			inputs.add(new NeuralNetworkData(0d,1d));
			inputs.add(new NeuralNetworkData(1d,0d));
			inputs.add(new NeuralNetworkData(1d,1d));		
			final List<NeuralNetworkData> expectedOutputs=new ArrayList<NeuralNetworkData>();
			expectedOutputs.add(new NeuralNetworkData(1d));
			expectedOutputs.add(new NeuralNetworkData(0d));
			expectedOutputs.add(new NeuralNetworkData(0d));
			expectedOutputs.add(new NeuralNetworkData(1d));
			expectedOutputs.add(new NeuralNetworkData(1d));
			expectedOutputs.add(new NeuralNetworkData(0d));
			expectedOutputs.add(new NeuralNetworkData(0d));
			expectedOutputs.add(new NeuralNetworkData(1d));
			expectedOutputs.add(new NeuralNetworkData(1d));
			expectedOutputs.add(new NeuralNetworkData(0d));
			expectedOutputs.add(new NeuralNetworkData(0d));
			expectedOutputs.add(new NeuralNetworkData(1d));
			expectedOutputs.add(new NeuralNetworkData(1d));
			expectedOutputs.add(new NeuralNetworkData(0d));
			expectedOutputs.add(new NeuralNetworkData(0d));
			expectedOutputs.add(new NeuralNetworkData(1d));	
			
			nn.train(inputs,expectedOutputs,new RPNeuralNetworkTrainingStrategy());
    	}
    	catch(Exception e)
    	{
    		fail(e.getMessage());
    	}
	}	
}
