/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.nn.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.nn.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class NeuralNetworkBuilderServiceTest extends AbstractDbUnitJpaTests implements NeuralNetworkBuilderServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private NeuralNetworkBuilderService neuralNetworkBuilderService;

    
    //
    // Instance methods
    //
    
    @Autowired
    public void setNeuralNetworkBuilderService(NeuralNetworkBuilderService neuralNetworkBuilderService) 
    {
        this.neuralNetworkBuilderService=neuralNetworkBuilderService;
    }

    @Test
    public void testGetNeuralNetwork() throws Exception 
    {
    	try
    	{
    		final NeuralNetwork ann=neuralNetworkBuilderService.getNeuralNetwork(5,3,8,0);
     		assertNotNull(ann);
     		assertEquals(ann.getInputNeuronsCount(),5);
     		assertEquals(ann.getOutputNeuronsCount(),3);
     		assertEquals(ann.getHiddenNeuronsCount(),8);     		
    	}
    	catch(Exception e)
    	{
    		e.printStackTrace();    		
    		fail(e.getMessage());
    	}
    }

    @Test
	public void testGetNeuralNetworksList() throws Exception 
	{
    	try
    	{
    		for (NeuralNetworkBuilderConfiguration cfg:NeuralNetworkBuilderConfiguration.values())
    		{
    			final List<NeuralNetwork> anns=neuralNetworkBuilderService.getNeuralNetworksList(5,3,cfg);
    			assertNotNull(anns);
    			for (NeuralNetwork ann:anns)
    			{
    				assertEquals(ann.getInputNeuronsCount(),5);
    				assertEquals(ann.getOutputNeuronsCount(),3);
    			}
    		}
    	}
    	catch(Exception e)
    	{
    		e.printStackTrace();    		
    		fail(e.getMessage());
    	}
	}
}
