/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.nn.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.nn.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class NeuralNetworksAggregateBuilderServiceTest extends AbstractDbUnitJpaTests implements NeuralNetworksAggregateBuilderServiceTestBase 
{
	//
	// Instance methods
	//
	
	/** */
    private NeuralNetworksAggregateBuilderService neuralNetworksAggregateBuilderService;

    
    //
    // Instance fields
    //
    
    @Autowired
    public void setNeuralNetworksAggregateBuilderService(NeuralNetworksAggregateBuilderService neuralNetworksAggregateBuilderService) 
    {
        this.neuralNetworksAggregateBuilderService=neuralNetworksAggregateBuilderService;
    }

    @Test
    public void testGetNeuralNetworksAggregate() throws Exception 
    {
		final List<NeuralNetworkData> inputs=new ArrayList<NeuralNetworkData>();
		inputs.add(new NeuralNetworkData(0d,0d));
		inputs.add(new NeuralNetworkData(0d,1d));
		inputs.add(new NeuralNetworkData(1d,0d));
		inputs.add(new NeuralNetworkData(1d,1d));
		inputs.add(new NeuralNetworkData(0d,0d));
		inputs.add(new NeuralNetworkData(0d,1d));
		inputs.add(new NeuralNetworkData(1d,0d));
		inputs.add(new NeuralNetworkData(1d,1d));
		inputs.add(new NeuralNetworkData(0d,0d));
		inputs.add(new NeuralNetworkData(0d,1d));
		inputs.add(new NeuralNetworkData(1d,0d));
		inputs.add(new NeuralNetworkData(1d,1d));
		inputs.add(new NeuralNetworkData(0d,0d));
		inputs.add(new NeuralNetworkData(0d,1d));
		inputs.add(new NeuralNetworkData(1d,0d));
		inputs.add(new NeuralNetworkData(1d,1d));		
		final List<NeuralNetworkData> expectedOutputs=new ArrayList<NeuralNetworkData>();
		expectedOutputs.add(new NeuralNetworkData(1d));
		expectedOutputs.add(new NeuralNetworkData(0d));
		expectedOutputs.add(new NeuralNetworkData(0d));
		expectedOutputs.add(new NeuralNetworkData(1d));
		expectedOutputs.add(new NeuralNetworkData(1d));
		expectedOutputs.add(new NeuralNetworkData(0d));
		expectedOutputs.add(new NeuralNetworkData(0d));
		expectedOutputs.add(new NeuralNetworkData(1d));
		expectedOutputs.add(new NeuralNetworkData(1d));
		expectedOutputs.add(new NeuralNetworkData(0d));
		expectedOutputs.add(new NeuralNetworkData(0d));
		expectedOutputs.add(new NeuralNetworkData(1d));
		expectedOutputs.add(new NeuralNetworkData(1d));
		expectedOutputs.add(new NeuralNetworkData(0d));
		expectedOutputs.add(new NeuralNetworkData(0d));
		expectedOutputs.add(new NeuralNetworkData(1d));		
		
		final NeuralNetworksAggregate nna=neuralNetworksAggregateBuilderService.getNeuralNetworksAggregate(inputs,expectedOutputs);
		assertNotNull(nna);
		assertNotNull(nna.getBestNeuralNetwork());
		assertNotNull(nna.getNeuralNetworks());
		assertNotNull(nna.getNeuralNetworks().size());		
    }

}
