/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 */
package org.doopyon.ravanelab.prediction.serviceapi;

import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.core.domain.tests.*;
import org.doopyon.ravanelab.core.serviceapi.*;
import org.doopyon.ravanelab.helpers.serviceapi.*;
import org.doopyon.ravanelab.prediction.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class MatchPredictionBuilderServiceTest extends AbstractDbUnitJpaTests implements MatchPredictionBuilderServiceTestBase 
{
	//
	// Instance fields
	//
	
	/** */
    private MatchPredictionBuilderService matchPredictionBuilderService;
	/** */
    private FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService;   
	/** */
    private MatchPredictionContextBuilderService matchPredictionContextBuilderService;
	/** */
    private LeagueSeasonRankingService leagueSeasonRankingService;
    
    
	//
	// Instance methods
	//
    
    @Autowired
    public void setMatchPredictionService(MatchPredictionBuilderService matchPredictionBuilderService) 
    {
        this.matchPredictionBuilderService=matchPredictionBuilderService;
    }

    @Autowired
	public void setFakeLeagueSeasonBuilderService(FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService) 
	{
		this.fakeLeagueSeasonManagerService=fakeLeagueSeasonManagerService;
	}        

    @Autowired
    public void setMatchPredictionContextBuilderService(MatchPredictionContextBuilderService matchPredictionContextBuilderService) 
    {
        this.matchPredictionContextBuilderService=matchPredictionContextBuilderService;
    }    
    
    @Autowired
    public void setLeagueRankingService(LeagueSeasonRankingService leagueRankingService) 
    {	
        this.leagueSeasonRankingService=leagueRankingService;
    }    
    
    @Test
    @Override
    public void testGetMatchPrediction() throws Exception 
    {
		final League league=LeagueSeasonTestUtil.buildLeagueForTesting(fakeLeagueSeasonManagerService);
		
		final MatchPredictionContext matchPredictionContext=matchPredictionContextBuilderService.getMatchPredictionContext(league,LeagueSeasonTestUtil.MIN_YEAR,1,LeagueSeasonTestUtil.MAX_YEAR-1,LeagueSeasonTestUtil.NB_MATCHWEEK_PER_SEASON);        
		final Match m=league.getLeagueSeasonForYear(LeagueSeasonTestUtil.MAX_YEAR).getMatchWeek(1).getMatchs().iterator().next();	
		final LeagueSeasonRanking lsr=leagueSeasonRankingService.getLeagueSeasonRanking(league,LeagueSeasonTestUtil.MAX_YEAR,0);;
		
		for (MatchPredictionStrategy mps:MatchPredictionStrategy.values())
		{
			final MatchEvaluation eval=matchPredictionBuilderService.getMatchPrediction(matchPredictionContext,mps,m,lsr);
			assertNotNull(eval);
			assertNotSame(MatchEvaluation.NOTPLAYED,eval);
			//assertNotSame(MatchEvaluation.UNDEFINED,eval);			
		}
    }
}
