/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 */
package org.doopyon.ravanelab.prediction.serviceapi;

import java.util.*;
import org.doopyon.ravanelab.core.domain.*;
import org.doopyon.ravanelab.core.domain.tests.*;
import org.doopyon.ravanelab.core.serviceapi.*;
import org.doopyon.ravanelab.helpers.serviceapi.*;
import org.doopyon.ravanelab.prediction.domain.*;
import org.fornax.cartridges.sculptor.framework.test.*;
import org.junit.*;
import org.springframework.beans.factory.annotation.*;


/**
 * Spring based transactional test with DbUnit support.
 * 
 * 
 */
public class MatchPredictionFacadeServiceTest extends AbstractDbUnitJpaTests implements MatchPredictionFacadeServiceTestBase 
{
	/** */
    private MatchPredictionFacadeService matchPredictionFacadeService;
	/** */
    private FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService;
	/** */
    private LeagueService leagueService;
    
    
	//
	// Instance methods
	//
    
    @Autowired
    public void setMatchPredictionFacadeService(MatchPredictionFacadeService matchPredictionFacadeService) 
    {
        this.matchPredictionFacadeService=matchPredictionFacadeService;
    }


    @Autowired
	public void setFakeLeagueSeasonBuilderService(FakeLeagueSeasonManagerService fakeLeagueSeasonManagerService) 
	{
		this.fakeLeagueSeasonManagerService=fakeLeagueSeasonManagerService;
	}      
    
    @Autowired
    public void setLeagueService(LeagueService leagueService) 
    {
        this.leagueService=leagueService;
    }    
    
    @Test
    @Override
    public void testGetMatchWeekPrediction() throws Exception 
    {
		final League league=leagueService.save(LeagueSeasonTestUtil.buildLeagueForTesting(fakeLeagueSeasonManagerService));
		
		final List<MatchPrediction> r=matchPredictionFacadeService.getMatchWeekPrediction(league.getLeagueName(),LeagueSeasonTestUtil.MAX_YEAR,1);
		
		assertNotNull(r);
		assertNotSame(0,r.size());
		
		for (MatchPrediction mp:r)
		{
			assertNotNull(mp);
			assertNotNull(mp.getHomeTeam());
			assertNotNull(mp.getAwayTeam());
			assertNotNull(mp.getPredictedEvaluation());
		}
    }
}
