/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.util;

import static org.junit.Assert.*;
import java.io.*;
import java.util.*;
import javax.swing.text.html.parser.*;
import org.junit.*;


/**
 * HTMLTableToCSVCallbackTest test.
 * 
 * @author Olivier PARISOT
 */
public class HTMLTableToCSVCallbackTest 
{
	//
	// Test methods.
	//
	
	@Test
	public void testHTMLTableToCSVCallback()
	{				
		final HTMLTableToCSVCallback cb=new HTMLTableToCSVCallback();
		
		try 
		{ 
			final BufferedReader breader=new BufferedReader((new StringReader("<table><tr><td>a</td><td>b</td></tr><tr><td>c</td><td>d</td></tr></table>")));
			final ParserDelegator pd=new ParserDelegator();
			pd.parse(breader,cb,true);
			breader.close();
		}
		catch(Exception e) 
		{ 
		  	e.printStackTrace(); 
		}        
		
		final List<String[]> lines=cb.getTable();

		assertEquals(2,lines.size());
		assertEquals(2,lines.get(0).length);
		assertEquals("a",lines.get(0)[0]);
		assertEquals("b",lines.get(0)[1]);
		assertEquals(2,lines.get(1).length);
		assertEquals("c",lines.get(1)[0]);
		assertEquals("d",lines.get(1)[1]);		
	}
}
