/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.util;

import org.junit.*;
import static org.junit.Assert.*;


/**
 * Maths utility test class.
 * 
 * @author Olivier PARISOT
 */
public final class MathsUtilTest 
{
	//
	// Test methods.
	//
	
	@Test
	public void testIndexOfMinValue()
	{
		assertEquals(MathsUtil.getIndexOfMinValue(new double[]{7d,5d,2d}),2);
		assertEquals(MathsUtil.getIndexOfMinValue(new double[]{1d,15d,2d}),0);
		assertEquals(MathsUtil.getIndexOfMinValue(new double[]{7d,5d,22d}),1);
		assertEquals(MathsUtil.getIndexOfMinValue(new double[]{0.5,0.5,1}),0);
	}
	
	@Test
	public void testIndexOfMaxValue()
	{
		assertEquals(MathsUtil.getIndexOfMaxValue(new double[]{7d,5d,2d}),0);
		assertEquals(MathsUtil.getIndexOfMaxValue(new double[]{1d,15d,2d}),1);
		assertEquals(MathsUtil.getIndexOfMaxValue(new double[]{7d,5d,22d}),2);
		assertEquals(MathsUtil.getIndexOfMaxValue(new double[]{0.5,0.5,1}),2);
	}
	
	@Test
	public void testAreTheSame()
	{
		assertTrue(MathsUtil.areTheSame(17d,17d));
		assertFalse(MathsUtil.areTheSame(17d,18d));
	}	
	

}
