/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.util;

import org.junit.*;
import static org.junit.Assert.*;


/**
 * Repartition delta test class.
 * 
 * @author Olivier PARISOT
 */
public final class RepartitionDeltaTest 
{
	//
	// Test methods.
	//
	
	@Test
	public void testRepartitionDeltaConstructorWithNullArgument()
	{
		try
		{
			new RepartitionDelta<String>(null,null);
			fail("No exception when args are null!");
		}
		catch(Exception e) 
		{
			assertTrue(true);
		}
	}
	
	@Test
	public void testRepartitionDeltaContent()
	{
		RepartitionDelta<String> delta=null;
		try
		{
			final Repartition<String> repBefore=new Repartition<String>();
			repBefore.addOccurenceFor("blabla");
			repBefore.addOccurenceFor("feur");
			repBefore.addOccurenceFor("feur");
			final Repartition<String> repAfter=new Repartition<String>();
			repAfter.addOccurenceFor("plutplut");
			repAfter.addOccurenceFor("feur");			
			delta=new RepartitionDelta<String>(repBefore,repAfter);					
		}
		catch(Exception e) 
		{
			e.printStackTrace();
			fail(e.getMessage());			
		}
		
		assertEquals(-1d,delta.getDelta("blabla"),0d);
		assertEquals(1d,delta.getDelta("plutplut"),0d);
		assertEquals(-0.25d,delta.getDelta("feur"),0d);	
	}
}
