/*
 * Copyright (C) 2010 Olivier PARISOT <parisot_olivier@yahoo.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.doopyon.ravanelab.util.encoding;

import static org.junit.Assert.*;
import java.util.*;
import org.doopyon.ravanelab.util.encoding.serviceapi.*;
import org.doopyon.ravanelab.util.encoding.serviceimpl.*;
import org.junit.*;


/**
 * SimpleEncodingStrategyTest.
 * 
 * @author Olivier PARISOT
 */
public class SimpleEncodingStrategyTest 
{

	@Test
	public void testEncodeIntToBinary()
	{
		final EncodingStrategy bes=new SimpleEncodingStrategy();
		
		final List<Double> encodedInt1=bes.getEncodedInt(1,20);
		assertNotNull(encodedInt1);
		
		final List<Double> encodedInt2=bes.getEncodedInt(15,20);
		assertNotNull(encodedInt2);
		
		assertEquals(encodedInt1.size(),encodedInt2.size());
		
		final List<Double> encodedInt4=bes.getEncodedInt(20,20);
		assertNotNull(encodedInt4);
		final List<Double> encodedInt5=bes.getEncodedInt(0,20);
		assertNotNull(encodedInt5);		
	}	
	
}
